#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Kleinian Limit SetMod01.fsh  by  mla
//https://www.shadertoy.com/view/4dKyDd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Originally created by soma_arc - 2016
Modified by Matthew Arcus, 2018
This work is licensed under Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported.

Derived from: https://www.shadertoy.com/view/Xtt3DN

Show Kleinian limit set derived from 6 octahedrally symmetric Mobius transformation.
Each Mobius transformation is composed of inversion in a sphere, reflection down
the inversion axis (ie. reflection in the plane normal to the vector to the sphere
centre), and optionally a rotation about the inversion axis.

I've also added a periodic "hyperbolic translation", ie. a final unit-ball preserving
inversion, also optionally combined with a rotation.

Controls:
<mouse> : orientation
<up>,<down>: zoom
r: rotate figure
s: add rotation to Mobius inversions
t: translate in H3
u: post-translation rotation
*/

#define NOKEYS (__VERSION__ < 300)
//#define NOKEYS 1

//#define DEBUG

#if !defined DEBUG
#define assert(x) 0
#else
// Simple indications of when things are amiss.
// A point with an assertion failure is red (so here
// most failures are global so the entire screen is
// red). Could use colours to indicate which assertion
// has failed.
bool alert = false;
void assert(bool test) {
  if (!test) alert = true;
}
#endif

bool dorotate = true;
bool dotranslate = true;
bool dorotate1 = true;
bool dorotate2 = true;
bool dorotate3 = true;
const float PI = 3.14159;

mat3 rotationMatrix(vec3 axis, float angle) {
  axis = normalize(axis);
  float s = sin(angle);
  float c = cos(angle);
  float r = 1.0 - c;
  return mat3(axis.x * axis.x * r + c,
              axis.y * axis.x * r + axis.z * s,
              axis.z * axis.x * r - axis.y * s,
              axis.x * axis.y * r - axis.z * s,
              axis.y * axis.y * r + c,
              axis.z * axis.y * r + axis.x * s,
              axis.x * axis.z * r + axis.y * s,
              axis.y * axis.z * r - axis.x * s,
              axis.z * axis.z * r + c);
}

// Invert p in sphere (C,s2)
vec3 invert(vec3 p, vec3 C, float s2) {
  p -= C;
  p *= s2/dot(p,p);
  p += C;
  return p;
}

vec3 AXIS = normalize(vec3(0.1, 1, 0.5));
mat3 rmat = mat3(1);

vec3 translate(vec3 p, inout float scale) {
  float t = 0.2*iTime;
  float x0 = 0.5*sin(t)+0.01;
  float s0 = 0.5*(1.0-x0*x0)/x0;
  p.x -= x0 + s0;
  float k = s0*s0/dot(p,p);
  scale *= k;
  p *= k;
  p.x += x0 + s0;
  return p;
}

// Sphere radius
const float R2 = 1.0;
const int NSPHERES = 6;
struct SphereData {
  vec3 pos;
  vec3 dir;
  mat3 m;
} sphereData[NSPHERES];

void initSphereData(float theta) {
  const float X = 1.0;
  const float Y = 1.0;
  sphereData[0].pos = vec3(X, Y, 0);
  sphereData[1].pos = vec3(X, -Y, 0);
  sphereData[2].pos = vec3(-X, Y, 0);
  sphereData[3].pos = vec3(-X, -Y, 0);
  sphereData[4].pos = vec3(0, 0, 1.41421);
  sphereData[5].pos = vec3(0, 0, -1.41421);
  //sphereData[6].pos = vec3(1.0 + sqrt(3.0), 0, 0);
  //sphereData[7].pos = vec3(-1.0-sqrt(3.0), 0, 0);
  for (int i = 0; i < NSPHERES; i++) {
    sphereData[i].dir = normalize(sphereData[i].pos);
    sphereData[i].m = rotationMatrix(sphereData[i].dir,theta);
  }
}

float distance2(vec3 p, vec3 q) {
  return dot(p-q,p-q);
}

int MAX_KLEIN_ITERATION = 30;

vec2 rotate(in vec2 p, in float t) {
  return p * cos(-t) + vec2(p.y, -p.x) * sin(-t);
}

int orbit  = 0; // Used for coloring, so global for now.

vec3 sphereInvert(vec3 pos, vec3 circlePos, float r2){
  return ((pos - circlePos) * r2)/(dot(pos-circlePos,pos-circlePos)) + circlePos;
}

float distKlein(vec3 pos) {
  float dr = 1.0;
  if (dotranslate) pos = translate(pos,dr);
  if (dorotate1) pos *= rmat;
  // Don't unroll this loop!
  for (int loopNum = 0; loopNum < 1000; loopNum++) {
    if (loopNum == MAX_KLEIN_ITERATION) break;
    float d2;
    SphereData s;
    bool found = false;
    for (int i = 0; i < NSPHERES; i++) {
      s = sphereData[i];
      d2 = distance2(pos, s.pos); 
        if (d2 < R2) {
            found = true;
            break;
        }
    }
      if (!found) {
          orbit = loopNum;
          break;
      }
    float k = R2 / d2;
    dr *= k;
    pos = k*(pos-s.pos)+s.pos;
    pos = reflect(pos,s.dir);
    if (dorotate2) pos *= s.m;
  }
  
  float kleinSphereR = 0.41421;

#if 0
  float f = (length(pos) - 0.414) / dr;
  dr *= 1.0/dot(pos, pos);
  pos = sphereInvert(pos, vec3(0),1.0);
  return min(f,(length(pos) - kleinSphereR) / dr);
  return (length(pos) - kleinSphereR) /dr;
  return f;
#else
  //dr *= 1.0/dot(pos, pos);
  //pos = sphereInvert(pos, vec3(0), 1.0);
  return (length(pos) - kleinSphereR)/dr;
#endif
}

const vec4 K = vec4(1.0, .666, .333, 3.0);
vec3 hsv2rgb(const vec3 c){
  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float distFunc(vec3 p){
  //p = mod(p+1.5,3.0)-1.5;
  //return max(distKlein(p),p.z);
  return distKlein(p);
}

vec3 getNormal(const vec3 p){
  const vec2 d = vec2(0.001, 0);
  return normalize(vec3(distFunc(p + d.xyy) - distFunc(p - d.xyy),
                        distFunc(p + d.yxy) - distFunc(p - d.yxy),
                        distFunc(p + d.yyx) - distFunc(p - d.yyx)));
}

vec3 diffuseLighting(const vec3 p, const vec3 n, const vec3 diffuseColor,
                     const vec3 lightDir){
  float k = dot(n, lightDir);
  return max(k,0.1) * diffuseColor;
}

const int MAX_MARCHING_LOOP = 500;
float march(const vec3 origin, const vec3 ray, const float threshold){
  float rayLength = 0.0;
#if 1
  // Advance ray to unit sphere
  // dot(p + kr,p + kr) == 1
  // p.p + 2kp.r + k^2r.r - 1 = 0
  // float A = dot(ray,ray) = 1;
  float B = dot(origin,ray);
  float C = dot(origin,origin)-1.0;
  float D = B*B-C;
  if (D < 0.0) return 1e8;
  rayLength = max(-B-sqrt(D),0.0);
  assert(length(origin+rayLength*ray) - 1.0 < 1e-3);
#endif
  assert(rayLength >= 0.0);
  float dist;
  for(int i = 0 ; i < MAX_MARCHING_LOOP ; i++){
    vec3 rayPos = origin+rayLength*ray;
    float dist = distFunc(rayPos);
    if (dist < threshold) return rayLength;
    dist *= 0.5;
    dist = min(dist,0.1);
    rayLength += dist;
    if (rayLength > 10.0) break;
  }
  return 1e8;
}

vec3 lightDir = vec3(1, 4, 2);

vec3 calcColor(vec3 eye, vec3 ray){
  vec3 col = vec3(0);
  float eps = 0.0001;
  float rayLength = march(eye, ray, eps);
  if (rayLength < 1e8) {
    vec3 intersection = eye + ray * rayLength;
    vec3 matColor = vec3(0);
    vec3 normal = getNormal(intersection);
    matColor = hsv2rgb(vec3(0.1 + float(orbit) * 0.1 , 1., 1.));
    col += diffuseLighting(intersection, normal, matColor, lightDir);
    float specular = pow(max(0.0,dot(reflect(lightDir,normal),ray)),4.0);
    col += 0.3*specular*vec3(1);
  }
  return col;
}

vec3 calcRay (const vec3 eye, const vec3 target, const vec3 up, const float fov,
              const float width, const float height, const vec2 coord){
  float imagePlane = (height * .5) / tan(fov * .5);
  vec3 v = normalize(target - eye);
  vec3 xaxis = normalize(cross(v, up));
  vec3 yaxis =  normalize(cross(v, xaxis));
  vec3 center = v * imagePlane;
  vec3 origin = center - (xaxis * (width  *.5)) - (yaxis * (height * .5));
  vec3 ray = origin + (xaxis * coord.x) + (yaxis * (height - coord.y));
  return ray;
}

const float DISPLAY_GAMMA_COEFF = 1. / 2.2;
vec3 gammaCorrect(vec3 rgb) {
  return vec3((min(pow(rgb.r, DISPLAY_GAMMA_COEFF), 1.)),
              (min(pow(rgb.g, DISPLAY_GAMMA_COEFF), 1.)),
              (min(pow(rgb.b, DISPLAY_GAMMA_COEFF), 1.)));
}

const vec3 target = vec3(0, 0, 0);
const vec3 up = vec3(0, 1, 0);
float fov = radians(45.0);

vec3 transform(in vec3 p) {
  if (iMouse.x > 0.0) {
    float theta = -(2.0*iMouse.y-iResolution.y)/iResolution.y*PI;
    float phi = -(2.0*iMouse.x-iResolution.x)/iResolution.x*PI;
    p.yz = rotate(p.yz,-theta);
    p.zx = rotate(p.zx,phi);
  }
  if (dorotate) {
    float t = iTime;
    p.zx = rotate(p.zx,t * 0.2);
  }
  return p;
}

const int CHAR_I = 73;
const int CHAR_J = 74;
const int CHAR_R = 82;
const int CHAR_S = 83;
const int CHAR_T = 84;
const int CHAR_U = 85;
const int KEY_UP = 38;
const int KEY_DOWN = 40;

#if NOKEYS
bool keypress(int code) {
  return false;
}

int keycount(int key) {
  return 0;
}
#else
bool keypress(int code) {
    return texelFetch(iChannel0, ivec2(code,2),0).x != 0.0;
}

vec4 store(int i,int j) {
  return texelFetch(iChannel1, ivec2(i,j),0);
}

int keycount(int key) {
  return int(store(0,key).x);
}
#endif


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  fragColor = vec4(1,0,0,1);
  //return; // Crashes both Firefox and Chrome without this!
  dorotate = !keypress(CHAR_R);
  dorotate1 = !keypress(CHAR_S);
  dotranslate = !keypress(CHAR_T);
  dorotate2 = !keypress(CHAR_U);
  rmat = rotationMatrix(AXIS,0.1618*iTime);
  initSphereData(0.2*iTime);
  vec3 eye = vec3(0,0,2.75);
  eye.z *= 0.1*float(10+keycount(KEY_DOWN)-keycount(KEY_UP));
  const vec2 coordOffset = vec2(0.5);
  vec3 ray = calcRay(eye, target, up, fov,
                     iResolution.x, iResolution.y,
                     gl_FragCoord.xy /*+ coordOffset*/);
  eye = transform(eye);
  ray = transform(ray);
  ray = normalize(ray);
  lightDir = transform(lightDir);
  lightDir = normalize(lightDir);
  fragColor = vec4(gammaCorrect(calcColor(eye, ray)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

